/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.agraham.byteconverter;

import anywheresoftware.b4a.BA;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.SortedMap;

@BA.ShortName(value="ByteConverter")
public class ByteConverter {
    private static final double version = 1.1;
    private char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private ByteOrder endian = ByteOrder.BIG_ENDIAN;

    public void LIBRARY_DOC() {
    }

    public boolean getLittleEndian() {
        return this.endian == ByteOrder.LITTLE_ENDIAN;
    }

    public void setLittleEndian(boolean littleEndian) {
        this.endian = littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    public char[] CharsFromBytes(byte[] bytes) {
        CharBuffer cb = ByteBuffer.wrap(bytes).order(this.endian).asCharBuffer();
        char[] ca = new char[bytes.length / 2];
        cb.get(ca);
        return ca;
    }

    public byte[] CharsToBytes(char[] vals) {
        ByteBuffer bb = ByteBuffer.allocate(vals.length * 2).order(this.endian);
        CharBuffer cb = bb.asCharBuffer();
        cb.put(vals);
        return bb.array();
    }

    public float[] FloatsFromBytes(byte[] bytes) {
        FloatBuffer fb = ByteBuffer.wrap(bytes).order(this.endian).asFloatBuffer();
        float[] fa = new float[bytes.length / 4];
        fb.get(fa);
        return fa;
    }

    public byte[] FloatsToBytes(float[] vals) {
        ByteBuffer bb = ByteBuffer.allocate(vals.length * 4).order(this.endian);
        FloatBuffer fb = bb.asFloatBuffer();
        fb.put(vals);
        return bb.array();
    }

    public double[] DoublesFromBytes(byte[] bytes) {
        DoubleBuffer db = ByteBuffer.wrap(bytes).order(this.endian).asDoubleBuffer();
        double[] da = new double[bytes.length / 8];
        db.get(da);
        return da;
    }

    public byte[] DoublesToBytes(double[] vals) {
        ByteBuffer bb = ByteBuffer.allocate(vals.length * 8).order(this.endian);
        DoubleBuffer db = bb.asDoubleBuffer();
        db.put(vals);
        return bb.array();
    }

    public short[] ShortsFromBytes(byte[] bytes) {
        ShortBuffer sb = ByteBuffer.wrap(bytes).order(this.endian).asShortBuffer();
        short[] sa = new short[bytes.length / 2];
        sb.get(sa);
        return sa;
    }

    public byte[] ShortsToBytes(short[] vals) {
        ByteBuffer bb = ByteBuffer.allocate(vals.length * 2).order(this.endian);
        ShortBuffer sb = bb.asShortBuffer();
        sb.put(vals);
        return bb.array();
    }

    public int[] IntsFromBytes(byte[] bytes) {
        IntBuffer ib = ByteBuffer.wrap(bytes).order(this.endian).asIntBuffer();
        int[] ia = new int[bytes.length / 4];
        ib.get(ia);
        return ia;
    }

    public byte[] IntsToBytes(int[] vals) {
        ByteBuffer bb = ByteBuffer.allocate(vals.length * 4).order(this.endian);
        IntBuffer ib = bb.asIntBuffer();
        ib.put(vals);
        return bb.array();
    }

    public long[] LongsFromBytes(byte[] bytes) {
        LongBuffer lb = ByteBuffer.wrap(bytes).order(this.endian).asLongBuffer();
        long[] la = new long[bytes.length / 8];
        lb.get(la);
        return la;
    }

    public byte[] LongsToBytes(long[] vals) {
        ByteBuffer bb = ByteBuffer.allocate(vals.length * 8).order(this.endian);
        LongBuffer lb = bb.asLongBuffer();
        lb.put(vals);
        return bb.array();
    }

    public void ArrayCopy(Object src, int srcOffset, Object dest, int destOffset, int count) {
        System.arraycopy(src, srcOffset, dest, destOffset, count);
    }

    public String HexFromBytes(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        int i = 0;
        while (i < bytes.length) {
            int v = bytes[i] & 0xFF;
            hexChars[j++] = this.hexArray[v >> 4];
            hexChars[j++] = this.hexArray[v & 0xF];
            ++i;
        }
        return new String(hexChars);
    }

    public byte[] HexToBytes(String hex) throws Exception {
        if (hex.length() % 2 > 0) {
            throw new Exception("hex string has odd number of characters");
        }
        byte[] bytes = new byte[hex.length() / 2];
        int i = 0;
        int count = 0;
        boolean next = true;
        int val = 0;
        try {
            i = 0;
            while (i < hex.length()) {
                int chr = hex.charAt(i) - 48;
                if (chr > 9) {
                    chr -= 7;
                }
                if (chr > 15) {
                    chr -= 32;
                }
                val = (byte)((val << 4) + chr);
                boolean bl = next = !next;
                if (next) {
                    bytes[count] = val;
                    ++count;
                }
                ++i;
            }
            return bytes;
        }
        catch (RuntimeException e) {
            throw new Exception("Invalid character '" + hex.charAt(i) + "' in hex string");
        }
    }

    public String[] SupportedEncodings() {
        SortedMap<String, Charset> codings = Charset.availableCharsets();
        Set<String> set = codings.keySet();
        String[] sa = set.toArray(new String[0]);
        return sa;
    }

    public String StringFromBytes(byte[] bytes, String encoding) {
        try {
            return new String(bytes, 0, bytes.length, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] StringToBytes(String str, String encoding) {
        try {
            return str.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
    }

    public String FromChars(char[] chars) {
        return new String(chars);
    }

    public char[] ToChars(String str) {
        return str.toCharArray();
    }

    public double getVersion() {
        return 1.1;
    }
}

