/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.agraham.reflection;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4j.objects.NodeWrapper;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;

@BA.ShortName(value="Reflector")
@BA.Author(value="Andrew Graham")
@BA.Version(value=1.2f)
public class Reflection {
    private static final double version = 1.2;
    public Object Target;
    private static HashMap<String, Class<?>> primitives = new HashMap<String, Class<?>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("java.lang.boolean", Boolean.TYPE);
            this.put("java.lang.byte", Byte.TYPE);
            this.put("java.lang.char", Character.TYPE);
            this.put("java.lang.short", Short.TYPE);
            this.put("java.lang.int", Integer.TYPE);
            this.put("java.lang.long", Long.TYPE);
            this.put("java.lang.float", Float.TYPE);
            this.put("java.lang.double", Double.TYPE);
            this.put("Z", Boolean.TYPE);
            this.put("B", Byte.TYPE);
            this.put("C", Character.TYPE);
            this.put("S", Short.TYPE);
            this.put("I", Integer.TYPE);
            this.put("J", Long.TYPE);
            this.put("F", Float.TYPE);
            this.put("D", Double.TYPE);
        }
    };

    public void LIBRARY_DOC() {
    }

    private static Class<?> classforname(String string) {
        if (primitives.containsKey(string)) {
            return primitives.get(string);
        }
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
    }

    private static Object sethelper(String string, Class clazz) {
        if (clazz.isEnum()) {
            return Enum.valueOf(clazz, string);
        }
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return Boolean.parseBoolean(string);
            }
            if (clazz == Byte.TYPE) {
                return Byte.parseByte(string);
            }
            if (clazz == Character.TYPE) {
                return Character.valueOf(string.charAt(0));
            }
            if (clazz == Short.TYPE) {
                return Short.parseShort(string);
            }
            if (clazz == Integer.TYPE) {
                return Integer.parseInt(string);
            }
            if (clazz == Long.TYPE) {
                return Long.parseLong(string);
            }
            if (clazz == Float.TYPE) {
                return Float.valueOf(Float.parseFloat(string));
            }
            if (clazz == Double.TYPE) {
                return Double.parseDouble(string);
            }
        }
        return string;
    }

    private Object runmethod(String string, Object[] objectArray, Class<?>[] classArray) throws Exception {
        NoSuchMethodException noSuchMethodException = null;
        Class<?> clazz = Class.forName("java.lang.Object");
        Class<?> clazz2 = this.Target.getClass();
        Boolean bl = true;
        do {
            try {
                if (clazz2 == clazz) {
                    bl = false;
                }
                Method method = clazz2.getDeclaredMethod(string, classArray);
                method.setAccessible(true);
                return method.invoke(this.Target, objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                noSuchMethodException = noSuchMethodException2;
                clazz2 = clazz2.getSuperclass();
            }
            catch (InvocationTargetException invocationTargetException) {
                throw (Exception)invocationTargetException.getCause();
            }
        } while (bl.booleanValue());
        throw noSuchMethodException;
    }

    public void AddChangeListener(final BA bA, String string, String string2) throws Exception {
        final Object object = this.Target;
        final String string3 = string.toLowerCase();
        Method method = this.GetMethod(string2, null);
        ObservableValue observableValue = (ObservableValue)method.invoke(object, new Object[0]);
        if (bA.subExists(string3 + "_changed")) {
            observableValue.addListener(new ChangeListener(){

                public void changed(ObservableValue observableValue, Object object3, Object object2) {
                    bA.raiseEvent(object, string3 + "_changed", object3, object2);
                }
            });
        }
    }

    public void AddEventFilter(final BA bA, String string, String string2) throws Exception {
        final Node node = (Node)this.Target;
        final String string3 = string.toLowerCase();
        int n = string2.lastIndexOf(46);
        String string4 = string2.substring(0, n);
        String string5 = string2.substring(n + 1, string2.length());
        Class<?> clazz = Class.forName(string4);
        Field field = clazz.getDeclaredField(string5);
        field.setAccessible(true);
        EventType eventType = (EventType)field.get(null);
        if (bA.subExists(string3 + "_filter")) {
            node.addEventFilter(eventType, new EventHandler(){

                public void handle(Event event) {
                    bA.raiseEvent(node, string3 + "_filter", AbsObjectWrapper.ConvertToWrapper(new NodeWrapper.ConcreteEventWrapper(), event));
                }
            });
        }
    }

    public void AddEventHandler(final BA bA, String string, String string2) throws Exception {
        final Node node = (Node)this.Target;
        final String string3 = string.toLowerCase();
        int n = string2.lastIndexOf(46);
        String string4 = string2.substring(0, n);
        String string5 = string2.substring(n + 1, string2.length());
        Class<?> clazz = Class.forName(string4);
        Field field = clazz.getDeclaredField(string5);
        field.setAccessible(true);
        EventType eventType = (EventType)field.get(null);
        if (bA.subExists(string3 + "_event")) {
            node.addEventHandler(eventType, new EventHandler(){

                public void handle(Event event) {
                    bA.raiseEvent(node, string3 + "_event", AbsObjectWrapper.ConvertToWrapper(new NodeWrapper.ConcreteEventWrapper(), event));
                }
            });
        }
    }

    public void AddEventHandler2(final BA bA, String string, String string2) throws Exception {
        final Object object = this.Target;
        final String string3 = string.toLowerCase();
        Method method = this.GetMethod(string2, null);
        ObjectProperty objectProperty = (ObjectProperty)method.invoke(object, new Object[0]);
        if (bA.subExists(string3 + "_event")) {
            objectProperty.setValue((Object)new EventHandler(){

                public void handle(Event event) {
                    bA.raiseEvent(object, string3 + "_event", AbsObjectWrapper.ConvertToWrapper(new NodeWrapper.ConcreteEventWrapper(), event));
                }
            });
        }
    }

    public Object CreateObject(String string) {
        try {
            Class<?> clazz = Reflection.classforname(string);
            return clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Object CreateObject2(String string, Object[] objectArray, String[] stringArray) {
        Class[] classArray = new Class[objectArray.length];
        try {
            Class<?> clazz = Reflection.classforname(string);
            for (int i = 0; i < objectArray.length; ++i) {
                classArray[i] = Reflection.classforname(stringArray[i]);
            }
            Constructor<?> constructor = clazz.getConstructor(classArray);
            return constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Field GetFieldInfo(String string) throws Exception {
        Class<?> clazz = Class.forName("java.lang.Object");
        Class<?> clazz2 = this.Target.getClass();
        while (true) {
            try {
                Field field = clazz2.getDeclaredField(string);
                field.setAccessible(true);
                return field;
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                if ((clazz2 = clazz2.getSuperclass()) != clazz) continue;
                throw exception2;
            }
            break;
        }
    }

    public Object GetField(String string) throws Exception {
        Class<?> clazz = Class.forName("java.lang.Object");
        Class<?> clazz2 = this.Target.getClass();
        while (true) {
            try {
                Field field = clazz2.getDeclaredField(string);
                field.setAccessible(true);
                return field.get(this.Target);
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                if ((clazz2 = clazz2.getSuperclass()) != clazz) continue;
                throw exception2;
            }
            break;
        }
    }

    public Object GetField2(Field field) throws Exception {
        return field.get(this.Target);
    }

    public Object GetPublicField(String string) {
        try {
            Class<?> clazz = this.Target.getClass();
            Field field = clazz.getField(string);
            return field.get(this.Target);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Object GetStaticField(String string, String string2) throws Exception {
        Exception exception = null;
        Class<?> clazz = Class.forName("java.lang.Object");
        Class<?> clazz2 = Class.forName(string);
        while (true) {
            try {
                Field field = clazz2.getDeclaredField(string2);
                field.setAccessible(true);
                return field.get(null);
            }
            catch (Exception exception2) {
                exception = exception2;
                if ((clazz2 = clazz2.getSuperclass()) != clazz) continue;
                throw exception;
            }
            break;
        }
    }

    public void SetField(String string, String string2, String string3) throws Exception {
        Class<?> clazz = Class.forName("java.lang.Object");
        Class<?> clazz2 = this.Target.getClass();
        while (true) {
            try {
                Field field = clazz2.getDeclaredField(string);
                field.setAccessible(true);
                Object object = Reflection.sethelper(string2, Reflection.classforname(string3));
                field.set(this.Target, object);
                return;
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                if ((clazz2 = clazz2.getSuperclass()) != clazz) continue;
                throw exception2;
            }
            break;
        }
    }

    public void SetField2(String string, Object object) throws Exception {
        Class<?> clazz = Class.forName("java.lang.Object");
        Class<?> clazz2 = this.Target.getClass();
        while (true) {
            try {
                Field field = clazz2.getDeclaredField(string);
                field.setAccessible(true);
                field.set(this.Target, object);
                return;
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                if ((clazz2 = clazz2.getSuperclass()) != clazz) continue;
                throw exception2;
            }
            break;
        }
    }

    public void SetField3(Field field, String string, String string2) throws Exception {
        Object object = Reflection.sethelper(string, Reflection.classforname(string2));
        field.set(this.Target, object);
    }

    public void SetField4(Field field, Object object) throws Exception {
        field.set(this.Target, object);
    }

    public void SetPublicField(String string, String string2, String string3) {
        try {
            Class<?> clazz = this.Target.getClass();
            Field field = clazz.getField(string);
            Object object = Reflection.sethelper(string2, Reflection.classforname(string3));
            field.set(this.Target, object);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void SetPublicField2(String string, Object object) {
        try {
            Class<?> clazz = this.Target.getClass();
            Field field = clazz.getField(string);
            field.set(this.Target, object);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void SetStaticField(String string, String string2, String string3, String string4) throws Exception {
        Exception exception = null;
        Class<?> clazz = Class.forName("java.lang.Object");
        Class<?> clazz2 = Class.forName(string);
        while (true) {
            try {
                Field field = clazz2.getDeclaredField(string2);
                field.setAccessible(true);
                Object object = Reflection.sethelper(string3, Reflection.classforname(string4));
                field.set(null, object);
                return;
            }
            catch (Exception exception2) {
                exception = exception2;
                if ((clazz2 = clazz2.getSuperclass()) != clazz) continue;
                throw exception;
            }
            break;
        }
    }

    public void SetStaticField2(String string, String string2, Object object) throws Exception {
        Exception exception = null;
        Class<?> clazz = Class.forName("java.lang.Object");
        Class<?> clazz2 = Class.forName(string);
        while (true) {
            try {
                Field field = clazz2.getDeclaredField(string2);
                field.setAccessible(true);
                field.set(null, object);
                return;
            }
            catch (Exception exception2) {
                exception = exception2;
                if ((clazz2 = clazz2.getSuperclass()) != clazz) continue;
                throw exception;
            }
            break;
        }
    }

    public int[] TargetRank() {
        Class<?> clazz = this.Target.getClass();
        if (!clazz.isArray()) {
            return new int[0];
        }
        String string = clazz.getName();
        int n = 1 + string.lastIndexOf(91);
        int[] nArray = new int[n];
        Object object = this.Target;
        for (int i = 0; i < n; ++i) {
            int n2;
            nArray[i] = n2 = Array.getLength(object);
            if (0 >= n2) continue;
            object = Array.get(object, 0);
        }
        return nArray;
    }

    public Object GetArray(int[] nArray) {
        Object object = this.Target;
        for (int i = 0; i < nArray.length - 1; ++i) {
            object = Array.get(object, nArray[i]);
        }
        return Array.get(object, nArray[nArray.length - 1]);
    }

    public void SetArray(int[] nArray, String string, String string2) {
        Object object = this.Target;
        for (int i = 0; i < nArray.length - 1; ++i) {
            object = Array.get(object, nArray[i]);
        }
        Object object2 = Reflection.sethelper(string, Reflection.classforname(string2));
        Array.set(object, nArray[nArray.length - 1], object2);
    }

    public void SetArray2(int[] nArray, Object object) {
        Object object2 = this.Target;
        for (int i = 0; i < nArray.length - 1; ++i) {
            object2 = Array.get(object2, nArray[i]);
        }
        Array.set(object2, nArray[nArray.length - 1], object);
    }

    public boolean DebugMode(BA bA) throws Exception {
        Field field = bA.getClass().getField("debugMode");
        return (Boolean)field.get(bA);
    }

    public BA GetBA(BA bA) {
        return bA;
    }

    public Class<?> GetB4JClass(String string) {
        Class<?> clazz;
        try {
            clazz = Class.forName(BA.packageName + "." + string.toLowerCase(BA.cul));
        }
        catch (Exception exception) {
            throw new RuntimeException("Class " + string + " not found.");
        }
        return clazz;
    }

    public BA GetModuleBA(String string) {
        try {
            Class<?> clazz = Class.forName(BA.packageName + "." + string.toLowerCase(BA.cul));
            Field field = clazz.getDeclaredField("ba");
            field.setAccessible(true);
            return (BA)field.get(null);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Object GetMostCurrent(String string) {
        try {
            Class<?> clazz = Class.forName(BA.packageName + "." + string.toLowerCase(BA.cul));
            Field field = clazz.getDeclaredField("mostCurrent");
            field.setAccessible(true);
            return field.get(null);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Method GetMethod(String string, String[] stringArray) throws Exception {
        NoSuchMethodException noSuchMethodException = null;
        Class<?> clazz = Class.forName("java.lang.Object");
        Class<?> clazz2 = this.Target.getClass();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i] = Reflection.classforname(stringArray[i]);
        }
        while (true) {
            try {
                Method method = clazz2.getDeclaredMethod(string, classArray);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                noSuchMethodException = noSuchMethodException2;
                if ((clazz2 = clazz2.getSuperclass()) != clazz) continue;
                throw noSuchMethodException;
            }
            break;
        }
    }

    public Object InvokeMethod(Object object, Method method, Object[] objectArray) throws Exception {
        try {
            return method.invoke(object, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (Exception)invocationTargetException.getCause();
        }
    }

    public Object RunMethod(String string) throws Exception {
        return this.runmethod(string, new Object[0], new Class[0]);
    }

    public Object RunMethod2(String string, String string2, String string3) throws Exception {
        Object[] objectArray = new Object[1];
        Class[] classArray = new Class[]{Reflection.classforname(string3)};
        objectArray[0] = Reflection.sethelper(string2, classArray[0]);
        return this.runmethod(string, objectArray, classArray);
    }

    public Object RunMethod3(String string, String string2, String string3, String string4, String string5) throws Exception {
        Object[] objectArray = new Object[2];
        Class[] classArray = new Class[]{Reflection.classforname(string3), Reflection.classforname(string5)};
        objectArray[0] = Reflection.sethelper(string2, classArray[0]);
        objectArray[1] = Reflection.sethelper(string4, classArray[1]);
        return this.runmethod(string, objectArray, classArray);
    }

    public Object RunMethod4(String string, Object[] objectArray, String[] stringArray) throws Exception {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i] = Reflection.classforname(stringArray[i]);
        }
        return this.runmethod(string, objectArray, classArray);
    }

    public Object RunPublicmethod(String string, Object[] objectArray, String[] stringArray) {
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i] = Reflection.classforname(stringArray[i]);
        }
        try {
            Method method = this.Target.getClass().getMethod(string, classArray);
            return method.invoke(this.Target, objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public Object RunStaticMethod(String string, String string2, Object[] objectArray, String[] stringArray) throws Exception {
        NoSuchMethodException noSuchMethodException = null;
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        Class<?> clazz = Class.forName("java.lang.Object");
        Class<?> clazz2 = Class.forName(string);
        Class[] classArray = new Class[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            classArray[i] = Reflection.classforname(stringArray[i]);
        }
        do {
            try {
                Method method = clazz2.getDeclaredMethod(string2, classArray);
                method.setAccessible(true);
                return method.invoke(null, objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                noSuchMethodException = noSuchMethodException2;
                clazz2 = clazz2.getSuperclass();
            }
            catch (InvocationTargetException invocationTargetException) {
                throw (Exception)invocationTargetException.getCause();
            }
        } while (clazz2 != clazz);
        throw noSuchMethodException;
    }

    public String ToString() {
        return this.Target.toString();
    }

    public StackTraceElement[] GetStacktrace() {
        return new Throwable().getStackTrace();
    }

    public String[] ParseStackTraceElement(StackTraceElement stackTraceElement) {
        String[] stringArray = new String[]{stackTraceElement.getClassName(), stackTraceElement.getFileName(), Integer.toString(stackTraceElement.getLineNumber()), stackTraceElement.getMethodName(), stackTraceElement.toString()};
        return stringArray;
    }

    public void PrintStacktrace() {
        new Throwable("Print stack trace requested").printStackTrace();
    }

    public double getVersion() {
        return 1.2;
    }

    public String getTypeName() {
        return this.Target.getClass().getName();
    }

    public boolean getIsNull() {
        return this.Target == null;
    }
}

