/*
 * Decompiled with CFR 0.152.
 */
package com.jamesmurty.utils;

import anywheresoftware.b4a.BA;
import com.jamesmurty.utils.NamespaceContextImpl;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@BA.Author(value="James Murty")
@BA.ShortName(value="XMLBuilder")
@BA.Version(value=1.0f)
public class XMLBuilder {
    private Document xmlDocument = null;
    private Element xmlElement = null;
    private static boolean isNamespaceAware = true;

    public XMLBuilder() {
    }

    protected XMLBuilder(Document xmlDocument) {
        this.xmlDocument = xmlDocument;
        this.xmlElement = xmlDocument.getDocumentElement();
    }

    protected XMLBuilder(Element myElement, Element parentElement) {
        this.xmlElement = myElement;
        this.xmlDocument = myElement.getOwnerDocument();
        if (parentElement != null) {
            parentElement.appendChild(myElement);
        }
    }

    public static XMLBuilder create2(String name, String namespaceURI) throws ParserConfigurationException, FactoryConfigurationError {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(isNamespaceAware);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element rootElement = null;
        rootElement = namespaceURI != null && namespaceURI.length() > 0 ? document.createElementNS(namespaceURI, name) : document.createElement(name);
        document.appendChild(rootElement);
        return new XMLBuilder(document);
    }

    public static XMLBuilder create(String name) throws ParserConfigurationException, FactoryConfigurationError {
        return XMLBuilder.create2(name, null);
    }

    public static XMLBuilder parse(InputSource inputSource) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(isNamespaceAware);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(inputSource);
        return new XMLBuilder(document);
    }

    public XMLBuilder importXMLBuilder(XMLBuilder builder) {
        this.assertElementHasNoTextNodes(this.xmlElement);
        Node importedNode = this.getDocument().importNode(builder.root().GetElement(), true);
        this.xmlElement.appendChild(importedNode);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof XMLBuilder) {
            XMLBuilder other = (XMLBuilder)obj;
            return this.xmlDocument.equals(other.getDocument()) && this.xmlElement.equals(other.GetElement());
        }
        return false;
    }

    public Element GetElement() {
        return this.xmlElement;
    }

    public XMLBuilder root() {
        return new XMLBuilder(this.getDocument());
    }

    public Document getDocument() {
        return this.xmlDocument;
    }

    public Object xpathQuery2(String xpath, QName type, NamespaceContext nsContext) throws XPathExpressionException {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xPath = xpathFactory.newXPath();
        if (nsContext != null) {
            xPath.setNamespaceContext(nsContext);
        }
        XPathExpression xpathExp = xPath.compile(xpath);
        try {
            return xpathExp.evaluate(this.xmlElement, type);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Object xpathQuery(String xpath, QName type) throws XPathExpressionException {
        return this.xpathQuery2(xpath, type, null);
    }

    public XMLBuilder xpathFind2(String xpath, NamespaceContext nsContext) throws XPathExpressionException {
        Node foundNode = (Node)this.xpathQuery2(xpath, XPathConstants.NODE, nsContext);
        if (foundNode == null || foundNode.getNodeType() != 1) {
            throw new XPathExpressionException("XPath expression \"" + xpath + "\" does not resolve to an Element in context " + this.xmlElement + ": " + foundNode);
        }
        return new XMLBuilder((Element)foundNode, null);
    }

    public XMLBuilder xpathFind(String xpath) throws XPathExpressionException {
        return this.xpathFind2(xpath, null);
    }

    public XMLBuilder element(String name) {
        String prefix = this.getPrefixFromQualifiedName(name);
        String namespaceURI = this.xmlElement.lookupNamespaceURI(prefix);
        return this.element2(name, namespaceURI);
    }

    public XMLBuilder elem(String name) {
        return this.element(name);
    }

    public XMLBuilder e(String name) {
        return this.element(name);
    }

    public XMLBuilder element2(String name, String namespaceURI) {
        this.assertElementHasNoTextNodes(this.xmlElement);
        return new XMLBuilder(namespaceURI == null ? this.getDocument().createElement(name) : this.getDocument().createElementNS(namespaceURI, name), this.xmlElement);
    }

    public XMLBuilder elementBefore(String name) {
        String prefix = this.getPrefixFromQualifiedName(name);
        String namespaceURI = this.xmlElement.lookupNamespaceURI(prefix);
        return this.elementBefore2(name, namespaceURI);
    }

    public XMLBuilder elementBefore2(String name, String namespaceURI) {
        Element parentElement = (Element)this.xmlElement.getParentNode();
        this.assertElementHasNoTextNodes(parentElement);
        Element newElement = namespaceURI == null ? this.getDocument().createElement(name) : this.getDocument().createElementNS(namespaceURI, name);
        parentElement.insertBefore(newElement, this.xmlElement);
        return new XMLBuilder(newElement, null);
    }

    public XMLBuilder attribute(String name, String value) {
        this.xmlElement.setAttribute(name, value);
        return this;
    }

    public XMLBuilder attr(String name, String value) {
        return this.attribute(name, value);
    }

    public XMLBuilder a(String name, String value) {
        return this.attribute(name, value);
    }

    public XMLBuilder text(String value) {
        this.xmlElement.appendChild(this.getDocument().createTextNode(value));
        return this;
    }

    public XMLBuilder t(String value) {
        return this.text(value);
    }

    public XMLBuilder cdata(String data) {
        this.xmlElement.appendChild(this.getDocument().createCDATASection(data));
        return this;
    }

    public XMLBuilder data(String data) {
        return this.cdata(data);
    }

    public XMLBuilder d(String data) {
        return this.cdata(data);
    }

    public XMLBuilder comment(String comment) {
        this.xmlElement.appendChild(this.getDocument().createComment(comment));
        return this;
    }

    public XMLBuilder cmnt(String comment) {
        return this.comment(comment);
    }

    public XMLBuilder c(String comment) {
        return this.comment(comment);
    }

    public XMLBuilder instruction(String target, String data) {
        this.xmlElement.appendChild(this.getDocument().createProcessingInstruction(target, data));
        return this;
    }

    public XMLBuilder inst(String target, String data) {
        return this.instruction(target, data);
    }

    public XMLBuilder i(String target, String data) {
        return this.instruction(target, data);
    }

    public XMLBuilder reference(String name) {
        this.xmlElement.appendChild(this.getDocument().createEntityReference(name));
        return this;
    }

    public XMLBuilder ref(String name) {
        return this.reference(name);
    }

    public XMLBuilder r(String name) {
        return this.reference(name);
    }

    public XMLBuilder namespace2(String prefix, String namespaceURI) {
        if (prefix != null && prefix.length() > 0) {
            this.xmlElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespaceURI);
        } else {
            this.xmlElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", namespaceURI);
        }
        return this;
    }

    public XMLBuilder ns2(String prefix, String namespaceURI) {
        return this.attribute(prefix, namespaceURI);
    }

    public XMLBuilder namespace(String namespaceURI) {
        this.namespace2(null, namespaceURI);
        return this;
    }

    public XMLBuilder ns(String namespaceURI) {
        return this.namespace(namespaceURI);
    }

    public XMLBuilder up2(int steps) {
        Node currNode = this.xmlElement;
        int stepCount = 0;
        while (currNode.getParentNode() != null && stepCount < steps) {
            currNode = currNode.getParentNode();
            ++stepCount;
        }
        if (currNode instanceof Document) {
            return new XMLBuilder((Document)currNode);
        }
        return new XMLBuilder((Element)currNode, null);
    }

    public XMLBuilder up() {
        return this.up2(1);
    }

    protected void assertElementHasNoTextNodes(Node anXmlElement) {
        Node textNode = null;
        NodeList childNodes = anXmlElement.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            if (3 == childNodes.item(i).getNodeType()) {
                textNode = childNodes.item(i);
                break;
            }
            ++i;
        }
        if (textNode != null) {
            throw new IllegalStateException("Cannot add sub-element to element <" + anXmlElement.getNodeName() + "> that already contains the Text node: " + textNode);
        }
    }

    public void toWriter(boolean wholeDocument, Writer writer, Map<String, String> outputProperties) throws TransformerException {
        StreamResult streamResult = new StreamResult(writer);
        DOMSource domSource = null;
        domSource = wholeDocument ? new DOMSource(this.getDocument()) : new DOMSource(this.GetElement());
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer serializer = tf.newTransformer();
        if (outputProperties != null) {
            for (Map.Entry<String, String> entry : outputProperties.entrySet()) {
                serializer.setOutputProperty(entry.getKey(), entry.getValue());
            }
        }
        serializer.transform(domSource, streamResult);
    }

    public void toWriter2(Writer writer, Map<String, String> outputProperties) throws TransformerException {
        this.toWriter(true, writer, outputProperties);
    }

    public String asString2(Map<String, String> outputProperties) throws TransformerException {
        StringWriter writer = new StringWriter();
        this.toWriter2(writer, outputProperties);
        return writer.toString();
    }

    public String elementAsString(Map<String, String> outputProperties) throws TransformerException {
        StringWriter writer = new StringWriter();
        this.toWriter(false, writer, outputProperties);
        return writer.toString();
    }

    public String asString() throws TransformerException {
        HashMap<String, String> outputProperties = new HashMap<String, String>();
        outputProperties.put("omit-xml-declaration", "yes");
        return this.asString2(outputProperties);
    }

    public String elementAsString() throws TransformerException {
        HashMap<String, String> outputProperties = new HashMap<String, String>();
        outputProperties.put("omit-xml-declaration", "yes");
        return this.elementAsString(outputProperties);
    }

    public NamespaceContextImpl buildDocumentNamespaceContext() {
        return new NamespaceContextImpl(this.root().GetElement());
    }

    protected String getPrefixFromQualifiedName(String qualifiedName) {
        int colonPos = qualifiedName.indexOf(58);
        if (colonPos > 0) {
            return qualifiedName.substring(0, colonPos);
        }
        return null;
    }
}

