/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4x.object;

import anywheresoftware.b4a.BA;
import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.crypto.params.ParametersWithIV;

@BA.ShortName(value="B4XCipher")
@BA.Version(value=1.0f)
public class B4XEncryption {
    public byte[] Encrypt(byte[] Data2, String Password) throws Exception {
        SecureRandom rnd = new SecureRandom();
        byte[] salt = new byte[8];
        rnd.nextBytes(salt);
        byte[] iv = new byte[16];
        rnd.nextBytes(iv);
        PKCS5S2ParametersGenerator pGen = new PKCS5S2ParametersGenerator(new SHA1Digest());
        byte[] pkcs12PasswordBytes = Password.getBytes("UTF8");
        pGen.init(pkcs12PasswordBytes, salt, 1024);
        CBCBlockCipher aesCBC = new CBCBlockCipher(new AESEngine());
        ParametersWithIV aesCBCParams = new ParametersWithIV(pGen.generateDerivedParameters(128), iv);
        aesCBC.init(true, aesCBCParams);
        PaddedBufferedBlockCipher aesCipher = new PaddedBufferedBlockCipher(aesCBC, new PKCS7Padding());
        aesCipher.init(true, pGen.generateDerivedParameters(128));
        byte[] plainTemp = new byte[aesCipher.getOutputSize(Data2.length)];
        int offset = aesCipher.processBytes(Data2, 0, Data2.length, plainTemp, 0);
        int last = aesCipher.doFinal(plainTemp, offset);
        byte[] plain = new byte[offset + last + 24];
        System.arraycopy(salt, 0, plain, 0, 8);
        System.arraycopy(iv, 0, plain, 8, 16);
        System.arraycopy(plainTemp, 0, plain, 24, offset + last);
        return plain;
    }

    public byte[] Decrypt(byte[] Data2, String Password) throws DataLengthException, IllegalStateException, InvalidCipherTextException, UnsupportedEncodingException {
        byte[] salt = new byte[8];
        byte[] iv = new byte[16];
        System.arraycopy(Data2, 0, salt, 0, 8);
        System.arraycopy(Data2, 8, iv, 0, 16);
        PKCS5S2ParametersGenerator pGen = new PKCS5S2ParametersGenerator(new SHA1Digest());
        byte[] pkcs12PasswordBytes = Password.getBytes("UTF8");
        pGen.init(pkcs12PasswordBytes, salt, 1024);
        CBCBlockCipher aesCBC = new CBCBlockCipher(new AESEngine());
        ParametersWithIV aesCBCParams = new ParametersWithIV(pGen.generateDerivedParameters(128), iv);
        aesCBC.init(false, aesCBCParams);
        PaddedBufferedBlockCipher aesCipher = new PaddedBufferedBlockCipher(aesCBC, new PKCS7Padding());
        aesCipher.init(false, pGen.generateDerivedParameters(128));
        byte[] plainTemp = new byte[aesCipher.getOutputSize(Data2.length - 24)];
        int offset = aesCipher.processBytes(Data2, 24, Data2.length - 24, plainTemp, 0);
        int last = aesCipher.doFinal(plainTemp, offset);
        byte[] plain = new byte[offset + last];
        System.arraycopy(plainTemp, 0, plain, 0, plain.length);
        return plain;
    }
}

