/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.randomaccessfile;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.ObjectWrapper;
import anywheresoftware.b4a.objects.collections.Map;
import anywheresoftware.b4a.randomaccessfile.B4XSerializator;
import anywheresoftware.b4a.randomaccessfile.BouncyCastleWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

@BA.ShortName(value="RandomAccessFile")
@BA.Version(value=2.34f)
public class RandomAccessFile {
    private FileChannel channel;
    private ByteBuffer bb4;
    private ByteBuffer bb8;
    private static final byte COMPRESS = 1;
    private static final byte ENCRYPT = 2;
    private static final ConcurrentHashMap<String, String> correctedClasses = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, Boolean> knownTypes = new ConcurrentHashMap();
    public long CurrentPosition;
    private static final byte LIST_TYPE = 1;
    private static final byte WRAPPED = 2;
    private static final byte NOT_WRAPPED = 3;
    private static final byte MAP_TYPE = 4;
    private static final byte ARRAY_TYPE = 5;
    private static final byte SERIALIZED_TYPE = 6;
    private static final byte B4ATYPE_TYPE = 7;
    private static final byte NULL_TYPE = 8;

    public void Initialize(String Dir, String File2, boolean ReadOnly) throws FileNotFoundException {
        this.Initialize2(Dir, File2, ReadOnly, false);
    }

    public void Initialize2(String Dir, String File2, boolean ReadOnly, boolean LittleEndian) throws FileNotFoundException {
        java.io.RandomAccessFile raf = new java.io.RandomAccessFile(new File(Dir, File2), ReadOnly ? "r" : "rw");
        this.channel = raf.getChannel();
        this.bb4 = ByteBuffer.allocateDirect(4);
        this.bb8 = ByteBuffer.allocateDirect(8);
        if (LittleEndian) {
            this.bb4.order(ByteOrder.LITTLE_ENDIAN);
            this.bb8.order(ByteOrder.LITTLE_ENDIAN);
        }
        this.CurrentPosition = 0L;
    }

    public void Initialize3(byte[] Buffer2, boolean LittleEndian) {
        this.channel = new ByteArrayChannel(Buffer2);
        this.bb4 = ByteBuffer.allocateDirect(4);
        this.bb8 = ByteBuffer.allocateDirect(8);
        if (LittleEndian) {
            this.bb4.order(ByteOrder.LITTLE_ENDIAN);
            this.bb8.order(ByteOrder.LITTLE_ENDIAN);
        }
        this.CurrentPosition = 0L;
    }

    public long getSize() throws IOException {
        return this.channel.size();
    }

    public void Close() throws IOException {
        this.channel.close();
    }

    public void Flush() throws IOException {
        this.channel.force(true);
    }

    public int ReadInt(long Position2) throws IOException {
        this.bb4.clear();
        this.channel.read(this.bb4, Position2);
        this.bb4.flip();
        this.CurrentPosition = Position2 + 4L;
        return this.bb4.getInt();
    }

    public float ReadFloat(long Position2) throws IOException {
        this.bb4.clear();
        this.channel.read(this.bb4, Position2);
        this.bb4.flip();
        this.CurrentPosition = Position2 + 4L;
        return this.bb4.getFloat();
    }

    public short ReadShort(long Position2) throws IOException {
        this.bb4.clear();
        this.bb4.limit(2);
        this.channel.read(this.bb4, Position2);
        this.bb4.flip();
        this.CurrentPosition = Position2 + 2L;
        return this.bb4.getShort();
    }

    public long ReadLong(long Position2) throws IOException {
        this.bb8.clear();
        this.channel.read(this.bb8, Position2);
        this.bb8.flip();
        this.CurrentPosition = Position2 + 8L;
        return this.bb8.getLong();
    }

    public double ReadDouble(long Position2) throws IOException {
        this.bb8.clear();
        this.channel.read(this.bb8, Position2);
        this.bb8.flip();
        this.CurrentPosition = Position2 + 8L;
        return this.bb8.getDouble();
    }

    public int ReadUnsignedByte(long Position2) throws IOException {
        this.CurrentPosition = Position2 + 1L;
        return this.ReadSignedByte(Position2) & 0xFF;
    }

    public byte ReadSignedByte(long Position2) throws IOException {
        this.CurrentPosition = Position2 + 1L;
        this.bb4.clear();
        this.bb4.limit(1);
        this.channel.read(this.bb4, Position2);
        this.bb4.flip();
        return this.bb4.get();
    }

    public int ReadBytes(byte[] Buffer2, int StartOffset, int Length, long Position2) throws IOException {
        int read = 0;
        while (read < Length) {
            int c = this.channel.read(ByteBuffer.wrap(Buffer2, StartOffset + read, Length - read), Position2 + (long)read);
            if (c == -1) break;
            read += c;
        }
        this.CurrentPosition = Position2 + (long)read;
        return read;
    }

    public void WriteInt(int Value, long Position2) throws IOException {
        this.bb4.clear();
        this.bb4.putInt(Value);
        this.bb4.flip();
        this.CurrentPosition = Position2 + 4L;
        this.channel.write(this.bb4, Position2);
    }

    public void WriteFloat(float Value, long Position2) throws IOException {
        this.bb4.clear();
        this.bb4.putFloat(Value);
        this.bb4.flip();
        this.CurrentPosition = Position2 + 4L;
        this.channel.write(this.bb4, Position2);
    }

    public void WriteShort(short Value, long Position2) throws IOException {
        this.bb4.clear();
        this.bb4.putShort(Value);
        this.bb4.flip();
        this.CurrentPosition = Position2 + 2L;
        this.channel.write(this.bb4, Position2);
    }

    public void WriteLong(long Value, long Position2) throws IOException {
        this.bb8.clear();
        this.bb8.putLong(Value);
        this.bb8.flip();
        this.CurrentPosition = Position2 + 8L;
        this.channel.write(this.bb8, Position2);
    }

    public void WriteDouble(double Value, long Position2) throws IOException {
        this.bb8.clear();
        this.bb8.putDouble(Value);
        this.bb8.flip();
        this.CurrentPosition = Position2 + 8L;
        this.channel.write(this.bb8, Position2);
    }

    public void WriteByte(byte Byte2, long Position2) throws IOException {
        this.bb4.clear();
        this.bb4.put(Byte2);
        this.bb4.flip();
        this.CurrentPosition = Position2 + 1L;
        this.channel.write(this.bb4, Position2);
    }

    public int WriteBytes(byte[] Buffer2, int StartOffset, int Length, long Position2) throws IOException {
        int written = 0;
        while (written < Length) {
            int w = this.channel.write(ByteBuffer.wrap(Buffer2, StartOffset + written, Length - written), Position2 + (long)written);
            written += w;
        }
        this.CurrentPosition = Position2 + (long)Length;
        return Length;
    }

    public void WriteB4XObject(Object Object2, long Position2) throws Exception {
        B4XSerializator bs = new B4XSerializator();
        byte[] arr = bs.WriteObject(Object2);
        this.WriteInt(arr.length, Position2);
        this.WriteByte((byte)1, this.CurrentPosition);
        this.WriteBytes(arr, 0, arr.length, this.CurrentPosition);
    }

    public Object ReadB4XObject(long Position2) throws Exception {
        B4XSerializator bs = new B4XSerializator();
        int len = this.ReadInt(Position2);
        ++this.CurrentPosition;
        byte[] arr = new byte[len];
        this.ReadBytes(arr, 0, arr.length, this.CurrentPosition);
        return bs.ReadObject(arr);
    }

    public void WriteObject(Object Object2, boolean Compress, long Position2) throws Exception {
        this.writeHelper(Compress ? (byte)1 : 0, Object2, null, Position2);
    }

    public void WriteEncryptedObject(Object Object2, String Password, long Position2) throws Exception {
        this.writeHelper((byte)2, Object2, Password, Position2);
    }

    private void writeHelper(byte mode, Object Object2, String password, long Position2) throws Exception {
        ObjectOutputStream out;
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        if (mode == 1 || mode == 2) {
            GZIPOutputStream gz = new GZIPOutputStream(bo);
            out = new ObjectOutputStream(gz);
        } else {
            out = new ObjectOutputStream(bo);
        }
        this.writeObject(out, Object2);
        out.close();
        byte[] b = bo.toByteArray();
        if (mode == 2) {
            b = this.encrypt(b, password);
        }
        int size = b.length + 1;
        this.WriteInt(size, Position2);
        this.WriteByte(mode, Position2 + 4L);
        ByteBuffer bb = ByteBuffer.wrap(b);
        int c = 0;
        int offset = 0;
        do {
            c = this.channel.write(bb, Position2 + 5L + (long)offset);
            offset += c;
        } while (c > 0);
        this.CurrentPosition = Position2 + (long)size - 1L + 5L;
    }

    private byte[] encrypt(byte[] data, String password) throws Exception {
        return BouncyCastleWrapper.encryptWithLWCrypto(data, password);
    }

    public Object ReadObject(long Position2) throws Exception {
        return this.readHelper(null, Position2);
    }

    public Object ReadEncryptedObject(String Password, long Position2) throws Exception {
        return this.readHelper(Password, Position2);
    }

    private Object readHelper(String password, long Position2) throws Exception {
        ObjectInputStream oin;
        int size = this.ReadInt(Position2);
        byte mode = this.ReadSignedByte(Position2 + 4L);
        byte[] b = new byte[size - 1];
        ByteBuffer bb = ByteBuffer.wrap(b);
        int i = this.channel.read(bb, Position2 + 5L);
        while (i < size) {
            int c = this.channel.read(bb, Position2 + 5L + (long)i);
            if (c == 0) break;
            i += c;
        }
        this.CurrentPosition = Position2 + 5L + (long)size - 1L;
        if (mode == 2) {
            if (password == null) {
                throw new RuntimeException("Data was encrypted. You should provide password.");
            }
            b = this.decrypt(b, password);
        }
        ByteArrayInputStream in = new ByteArrayInputStream(b);
        if (mode == 1 || mode == 2) {
            GZIPInputStream gin = new GZIPInputStream(in);
            oin = new ObjectInputStream(gin);
        } else {
            oin = new ObjectInputStream(in);
        }
        Object o = this.readObject(oin);
        oin.close();
        return o;
    }

    private byte[] decrypt(byte[] b, String password) throws Exception {
        return BouncyCastleWrapper.decryptWithLWCrypto(b, password);
    }

    private void writeObject(ObjectOutputStream out, Object o) throws IOException, IllegalArgumentException, IllegalAccessException {
        Object oo = o instanceof ObjectWrapper ? ((ObjectWrapper)o).getObject() : o;
        if (oo instanceof Map) {
            out.write(4);
            this.writeMap(out, o);
        } else if (oo instanceof List) {
            out.write(1);
            this.writeList(out, o);
        } else if (o != null && o.getClass().isArray()) {
            out.write(5);
            this.writeArray(out, o);
        } else if (o instanceof Serializable) {
            out.write(6);
            out.writeObject(o);
        } else if (o != null) {
            this.writeType(out, o);
        } else {
            out.write(8);
        }
    }

    private Object readObject(ObjectInputStream in) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Object o = null;
        switch (in.read()) {
            case 4: {
                o = this.readMap(in);
                break;
            }
            case 1: {
                o = this.readList(in);
                break;
            }
            case 5: {
                o = this.readArray(in);
                break;
            }
            case 6: {
                o = in.readObject();
                break;
            }
            case 7: {
                o = this.readType(in);
                break;
            }
            case 8: {
                o = null;
            }
        }
        return o;
    }

    @BA.Hide
    public static Field[] isB4XType(Object type) {
        Field[] fields = type.getClass().getDeclaredFields();
        Boolean IsInitializedField = knownTypes.get(type.getClass());
        if (IsInitializedField == null) {
            IsInitializedField = false;
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (f.getName().equals("IsInitialized")) {
                    IsInitializedField = true;
                    break;
                }
                ++n2;
            }
            knownTypes.put(type.getClass(), IsInitializedField);
        }
        return IsInitializedField != false ? fields : null;
    }

    private void writeType(ObjectOutputStream out, Object type) throws IOException, IllegalArgumentException, IllegalAccessException {
        Field[] fields = RandomAccessFile.isB4XType(type);
        if (fields == null) {
            out.write(8);
            return;
        }
        out.write(7);
        out.writeObject(type.getClass().getName());
        Map.MyMap map = new Map.MyMap();
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            f.setAccessible(true);
            map.put(f.getName(), f.get(type));
            ++n2;
        }
        this.writeMap(out, map);
    }

    @BA.Hide
    public static Class<?> readTypeClass(String className) throws ClassNotFoundException {
        Class<?> c;
        try {
            if (correctedClasses.containsKey(className)) {
                className = correctedClasses.get(className);
            }
            c = Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            int dollar = className.lastIndexOf(".");
            String corrected = dollar > -1 ? String.valueOf(BA.packageName) + className.substring(dollar) : String.valueOf(BA.packageName) + ".main$" + className;
            try {
                c = Class.forName(corrected);
            }
            catch (ClassNotFoundException cnfe2) {
                corrected = corrected.replace(".main$", ".b4xmainpage$");
                c = Class.forName(corrected);
            }
            correctedClasses.put(className, corrected);
        }
        return c;
    }

    private Object readType(ObjectInputStream in) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        String className = (String)in.readObject();
        Class<?> c = RandomAccessFile.readTypeClass(className);
        Map.MyMap map = (Map.MyMap)this.readMap(in);
        Object o = c.newInstance();
        Field[] fieldArray = c.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            Object val = map.get(f.getName());
            if (val != null || map.containsKey(f.getName())) {
                f.setAccessible(true);
                f.set(o, val);
            }
            ++n2;
        }
        return o;
    }

    private void writeMap(ObjectOutputStream out, Object m) throws IOException, IllegalArgumentException, IllegalAccessException {
        Map map;
        if (m instanceof ObjectWrapper) {
            map = (Map)((ObjectWrapper)m).getObject();
            out.write(2);
        } else {
            map = (Map)m;
            out.write(3);
        }
        out.writeInt(map.size());
        for (Map.Entry e : map.entrySet()) {
            this.writeObject(out, e.getKey());
            this.writeObject(out, e.getValue());
        }
    }

    private Object readMap(ObjectInputStream in) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        boolean shouldWrap = in.readByte() == 2;
        Map.MyMap Map2 = new Map.MyMap();
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            Object key = this.readObject(in);
            Object value = this.readObject(in);
            Map2.put(key, value);
            ++i;
        }
        if (shouldWrap) {
            anywheresoftware.b4a.objects.collections.Map m = new anywheresoftware.b4a.objects.collections.Map();
            m.setObject(Map2);
            return m;
        }
        return Map2;
    }

    private void writeArray(ObjectOutputStream out, Object array) throws IOException, IllegalArgumentException, IllegalAccessException {
        out.writeObject(array.getClass().getComponentType());
        int size = Array.getLength(array);
        out.writeInt(size);
        int i = 0;
        while (i < size) {
            this.writeObject(out, Array.get(array, i));
            ++i;
        }
    }

    private Object readArray(ObjectInputStream in) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class c = (Class)in.readObject();
        int size = in.readInt();
        Object arr = Array.newInstance(c, size);
        int i = 0;
        while (i < size) {
            Array.set(arr, i, this.readObject(in));
            ++i;
        }
        return arr;
    }

    private void writeList(ObjectOutputStream out, Object l) throws IOException, IllegalArgumentException, IllegalAccessException {
        List list;
        if (l instanceof ObjectWrapper) {
            list = (List)((ObjectWrapper)l).getObject();
            out.write(2);
        } else {
            list = (List)l;
            out.write(3);
        }
        out.writeInt(list.size());
        int i = 0;
        while (i < list.size()) {
            this.writeObject(out, list.get(i));
            ++i;
        }
    }

    private Object readList(ObjectInputStream in) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        boolean shouldWrap = in.readByte() == 2;
        ArrayList<Object> list = new ArrayList<Object>();
        int size = in.readInt();
        int i = 0;
        while (i < size) {
            list.add(this.readObject(in));
            ++i;
        }
        if (shouldWrap) {
            anywheresoftware.b4a.objects.collections.List l = new anywheresoftware.b4a.objects.collections.List();
            l.setObject(list);
            return l;
        }
        return list;
    }

    private static class ByteArrayChannel
    extends FileChannel {
        private byte[] buffer;

        public ByteArrayChannel(byte[] buffer) {
            this.buffer = buffer;
        }

        @Override
        public void force(boolean metaData) throws IOException {
        }

        @Override
        public FileLock lock(long position, long size, boolean shared) throws IOException {
            return null;
        }

        @Override
        public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
            return null;
        }

        @Override
        public long position() throws IOException {
            return 0L;
        }

        @Override
        public FileChannel position(long newPosition) throws IOException {
            return null;
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(ByteBuffer dst, long position) throws IOException {
            int pos = (int)position;
            while (dst.hasRemaining()) {
                dst.put(this.buffer[pos++]);
            }
            return pos - (int)position;
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            return 0L;
        }

        @Override
        public long size() throws IOException {
            return this.buffer.length;
        }

        @Override
        public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
            return 0L;
        }

        @Override
        public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
            return 0L;
        }

        @Override
        public FileChannel truncate(long size) throws IOException {
            return null;
        }

        @Override
        public FileLock tryLock(long position, long size, boolean shared) throws IOException {
            return null;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return 0;
        }

        @Override
        public int write(ByteBuffer src, long position) throws IOException {
            int pos = (int)position;
            while (src.hasRemaining()) {
                this.buffer[pos++] = src.get();
            }
            return pos - (int)position;
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            return 0L;
        }

        @Override
        protected void implCloseChannel() throws IOException {
        }
    }
}

