/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.AbsObjectWrapper;
import anywheresoftware.b4a.BA;
import anywheresoftware.b4a.keywords.Common;
import anywheresoftware.b4j.objects.NodeWrapper;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import javafx.util.Callback;

@BA.ShortName(value="TableView")
public class TableViewWrapper
extends NodeWrapper.ControlWrapper<TableView<Object[]>> {
    @Override
    @BA.Hide
    public void innerInitialize(final BA ba, final String eventName, boolean keepOldObject) {
        if (!keepOldObject) {
            this.setObject(new TableView());
        }
        super.innerInitialize(ba, eventName, true);
        if (ba.subExists(String.valueOf(eventName) + "_selectedrowchanged")) {
            ((TableView)this.getObject()).getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
                    if (((TableView)TableViewWrapper.this.getObject()).getSelectionModel().isCellSelectionEnabled()) {
                        return;
                    }
                    Object[] row = null;
                    if (arg2.intValue() > -1) {
                        row = (Object[])((TableView)TableViewWrapper.this.getObject()).getItems().get(arg2.intValue());
                    }
                    ba.raiseEventFromUI(TableViewWrapper.this.getObject(), String.valueOf(eventName) + "_selectedrowchanged", arg2.intValue(), row);
                }
            });
        }
        if (ba.subExists(String.valueOf(eventName) + "_selectedcellchanged")) {
            ((TableView)this.getObject()).getSelectionModel().getSelectedCells().addListener((ListChangeListener)new ListChangeListener<TablePosition>(){

                public void onChanged(ListChangeListener.Change<? extends TablePosition> arg0) {
                    if (!((TableView)TableViewWrapper.this.getObject()).getSelectionModel().isCellSelectionEnabled()) {
                        return;
                    }
                    if (arg0.getList().size() == 0) {
                        return;
                    }
                    TablePosition tp = (TablePosition)arg0.getList().get(0);
                    ba.raiseEventFromUI(TableViewWrapper.this.getObject(), String.valueOf(eventName) + "_selectedcellchanged", tp.getRow(), tp.getColumn(), ((Object[])tp.getTableView().getItems().get(tp.getRow()))[tp.getColumn()]);
                }
            });
        }
    }

    public void setSingleCellSelection(boolean b) {
        ((TableView)this.getObject()).getSelectionModel().setCellSelectionEnabled(b);
    }

    public boolean getSingleCellSelection() {
        return ((TableView)this.getObject()).getSelectionModel().isCellSelectionEnabled();
    }

    public void SetColumns(anywheresoftware.b4a.objects.collections.List Columns) {
        ((TableView)this.getObject()).getColumns().clear();
        if (Columns == null || !Columns.IsInitialized()) {
            return;
        }
        int colIndex = 0;
        double w = (this.getPrefWidth() - (double)Common.DipToCurrent(20)) / (double)Columns.getSize();
        for (Object colName : (List)Columns.getObject()) {
            TableColumn tc = new TableColumn(String.valueOf(colName));
            tc.setPrefWidth(w);
            tc.setCellValueFactory((Callback)new MyCellValueFactory(colIndex));
            ((TableView)this.getObject()).getColumns().add((Object)tc);
            ++colIndex;
        }
    }

    public int getColumnsCount() {
        return ((TableView)this.getObject()).getColumns().size();
    }

    public String GetColumnHeader(int Index) {
        return ((TableColumn)((TableView)this.getObject()).getColumns().get(Index)).getText();
    }

    public void SetColumnHeader(int Index, String Header2) {
        ((TableColumn)((TableView)this.getObject()).getColumns().get(Index)).setText(Header2);
    }

    public double GetColumnWidth(int Index) {
        return ((TableColumn)((TableView)this.getObject()).getColumns().get(Index)).getWidth();
    }

    public void SetColumnWidth(int Index, double Width) {
        ((TableColumn)((TableView)this.getObject()).getColumns().get(Index)).setPrefWidth(Width);
    }

    public void SetColumnSortable(int Index, boolean Sortable) {
        ((TableColumn)((TableView)this.getObject()).getColumns().get(Index)).setSortable(Sortable);
    }

    public void SetColumnVisible(int Index, boolean Visible) {
        ((TableColumn)((TableView)this.getObject()).getColumns().get(Index)).setVisible(Visible);
    }

    public boolean GetColumnVisible(int Index) {
        return ((TableColumn)((TableView)this.getObject()).getColumns().get(Index)).isVisible();
    }

    public int getSelectedRow() {
        return ((TableView)this.getObject()).getSelectionModel().getSelectedIndex();
    }

    public void setSelectedRow(int row) {
        ((TableView)this.getObject()).getSelectionModel().clearAndSelect(row);
    }

    public void ClearSelection() {
        ((TableView)this.getObject()).getSelectionModel().clearSelection();
    }

    public void SelectCell(int Row, int Column) {
        ((TableView)this.getObject()).getSelectionModel().clearAndSelect(Row, (TableColumn)((TableView)this.getObject()).getColumns().get(Column));
    }

    public Object[] getSelectedRowValues() {
        return (Object[])((TableView)this.getObject()).getSelectionModel().getSelectedItem();
    }

    public void setSelectedRowValues(Object[] r) {
        ((TableView)this.getObject()).getSelectionModel().clearSelection();
        ((TableView)this.getObject()).getSelectionModel().select((Object)r);
    }

    public void ScrollTo(int Index) {
        ((TableView)this.getObject()).scrollTo(Index);
    }

    public void setItems(anywheresoftware.b4a.objects.collections.List list) {
        ((TableView)this.getObject()).setItems(FXCollections.observableList((List)((List)list.getObject())));
    }

    public anywheresoftware.b4a.objects.collections.List getItems() {
        return (anywheresoftware.b4a.objects.collections.List)AbsObjectWrapper.ConvertToWrapper(new anywheresoftware.b4a.objects.collections.List(), ((TableView)this.getObject()).getItems());
    }

    public static Node build(Object prev, HashMap<String, Object> props, boolean designer, Object tag) throws Exception {
        TableView vg = (TableView)prev;
        if (vg == null) {
            vg = NodeWrapper.buildNativeView(TableView.class, props, designer);
        }
        NodeWrapper.ControlWrapper.build((Object)vg, props, designer);
        String rawColumns = (String)props.get("columns");
        TableViewWrapper tvw = new TableViewWrapper();
        tvw.setObject(vg);
        anywheresoftware.b4a.objects.collections.List l1 = new anywheresoftware.b4a.objects.collections.List();
        l1.Initialize();
        String[] stringArray = rawColumns.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if ((s = s.trim()).length() > 0) {
                l1.Add(s);
            }
            ++n2;
        }
        tvw.SetColumns(l1);
        return vg;
    }

    private static class MyCellValueFactory
    implements Callback<TableColumn.CellDataFeatures<Object[], Object>, ObservableValue<Object>> {
        private final int colIndex;

        public MyCellValueFactory(int colIndex) {
            this.colIndex = colIndex;
        }

        public ObservableValue<Object> call(TableColumn.CellDataFeatures<Object[], Object> arg0) {
            return new ReadOnlyObjectWrapper(((Object[])arg0.getValue())[this.colIndex]);
        }
    }
}

