/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4j.objects;

import anywheresoftware.b4a.BA;
import anywheresoftware.b4j.objects.LayoutBuilder;
import anywheresoftware.b4j.objects.NodeWrapper;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;

@BA.Hide
public class TextInputControlWrapper<T extends TextInputControl>
extends NodeWrapper.ControlWrapper<T>
implements LayoutBuilder.B4JTextControl {
    @Override
    @BA.Hide
    public void innerInitialize(final BA ba, final String eventName, boolean keepOldObject) {
        super.innerInitialize(ba, eventName, keepOldObject);
        if (ba.subExists(String.valueOf(eventName) + "_textchanged")) {
            ((TextInputControl)this.getObject()).textProperty().addListener((ChangeListener)new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> arg0, String old, String newValue) {
                    ba.raiseEventFromUI(TextInputControlWrapper.this.getObject(), String.valueOf(eventName) + "_textchanged", old, newValue);
                }
            });
        }
    }

    @Override
    public String getText() {
        return ((TextInputControl)this.getObject()).getText();
    }

    @Override
    public void setText(String s) {
        ((TextInputControl)this.getObject()).setText(s);
    }

    public String getPromptText() {
        return ((TextInputControl)this.getObject()).getPromptText();
    }

    public void setPromptText(String s) {
        ((TextInputControl)this.getObject()).setPromptText(s);
    }

    public int getSelectionStart() {
        return ((TextInputControl)this.getObject()).getSelection().getStart();
    }

    public int getSelectionEnd() {
        return ((TextInputControl)this.getObject()).getSelection().getEnd();
    }

    public void SetSelection(int StartIndex, int EndIndex) {
        ((TextInputControl)this.getObject()).selectRange(StartIndex, EndIndex);
    }

    public void SelectAll() {
        ((TextInputControl)this.getObject()).selectAll();
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + ", Text: " + this.getText() + ", ";
    }

    public boolean getEditable() {
        return ((TextInputControl)this.getObject()).isEditable();
    }

    public void setEditable(boolean b) {
        ((TextInputControl)this.getObject()).setEditable(b);
    }

    @BA.Hide
    public static Node build(Object prev, HashMap<String, Object> props, boolean designer) throws Exception {
        TextInputControl vg = (TextInputControl)prev;
        NodeWrapper.ControlWrapper.build((Object)vg, props, designer);
        vg.setText((String)props.get("text"));
        vg.setPromptText((String)props.get("prompt"));
        vg.setEditable(((Boolean)props.get("editable")).booleanValue());
        return vg;
    }

    @BA.ShortName(value="TextArea")
    public static class TextAreaWrapper
    extends TextInputControlWrapper<TextArea> {
        @Override
        @BA.Hide
        public void innerInitialize(BA ba, String eventName, boolean keepOldObject) {
            if (!keepOldObject) {
                this.setObject(new TextArea());
            }
            super.innerInitialize(ba, eventName, true);
        }

        public boolean getWrapText() {
            return ((TextArea)this.getObject()).isWrapText();
        }

        public void setWrapText(boolean b) {
            ((TextArea)this.getObject()).setWrapText(b);
        }

        public double getScrollTopPosition() {
            return ((TextArea)this.getObject()).getScrollTop();
        }

        public void setScrollTopPosition(double d) {
            ((TextArea)this.getObject()).setScrollTop(d);
        }

        public double getScrollLeftPosition() {
            return ((TextArea)this.getObject()).getScrollLeft();
        }

        public void setScrollLeftPosition(double d) {
            ((TextArea)this.getObject()).setScrollLeft(d);
        }

        @BA.Hide
        public static Node build(Object prev, HashMap<String, Object> props, boolean designer, Object tag) throws Exception {
            Node vg = (Node)prev;
            if (vg == null) {
                vg = (Node)NodeWrapper.buildNativeView(TextArea.class, props, designer);
            }
            vg = TextInputControlWrapper.build((Object)vg, props, designer);
            ((TextArea)vg).setWrapText(((Boolean)props.get("wrapText")).booleanValue());
            return vg;
        }
    }

    @BA.ShortName(value="TextField")
    public static class TextFieldWrapper
    extends TextInputControlWrapper<TextField> {
        public void InitializePassword(BA ba, String EventName) {
            this.setObject(new PasswordField());
            this.innerInitialize(ba, EventName.toLowerCase(BA.cul), true);
        }

        @Override
        @BA.Hide
        public void innerInitialize(final BA ba, final String eventName, boolean keepOldObject) {
            if (!keepOldObject) {
                this.setObject(new TextField());
            }
            super.innerInitialize(ba, eventName, true);
            if (ba.subExists(String.valueOf(eventName) + "_action")) {
                ((TextField)this.getObject()).setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent arg0) {
                        ba.raiseEventFromUI(TextFieldWrapper.this.getObject(), String.valueOf(eventName) + "_action", new Object[0]);
                        arg0.consume();
                    }
                });
            }
        }

        @BA.Hide
        public static Node build(Object prev, HashMap<String, Object> props, boolean designer, Object tag) throws Exception {
            Node vg = (Node)prev;
            boolean password = BA.gm(props, "password", false);
            if (vg == null || vg instanceof PasswordField != password) {
                vg = (Node)NodeWrapper.buildNativeView(password ? PasswordField.class : TextField.class, props, designer);
            }
            vg = TextInputControlWrapper.build((Object)vg, props, designer);
            return vg;
        }
    }
}

