/*
 * Decompiled with CFR 0.152.
 */
package anywheresoftware.b4a.keywords;

import anywheresoftware.b4a.BA;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class DateTime {
    public static final long TicksPerSecond = 1000L;
    public static final long TicksPerMinute = 60000L;
    public static final long TicksPerHour = 3600000L;
    public static final long TicksPerDay = 86400000L;
    private static final TimeZone zeroTimeZone = new SimpleTimeZone(0, "13256");
    private Date date;
    private static final ThreadLocal<DateTime> _instance = new ThreadLocal<DateTime>(){

        @Override
        protected DateTime initialValue() {
            return new DateTime(null);
        }
    };
    private Calendar cal = Calendar.getInstance(Locale.US);
    private SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private SimpleDateFormat timeFormat;
    @BA.Hide
    public TimeZone timeZone;

    @BA.Hide
    public static DateTime getInst() {
        return _instance.get();
    }

    private DateTime() {
        this.dateFormat.setLenient(false);
        this.timeFormat = new SimpleDateFormat("HH:mm:ss");
        this.timeFormat.setLenient(false);
        this.date = new Date(0L);
        this.timeZone = TimeZone.getDefault();
    }

    public static long getNow() {
        return System.currentTimeMillis();
    }

    public static String Date(long Ticks) {
        DateTime d = DateTime.getInst();
        d.date.setTime(Ticks);
        return d.dateFormat.format(d.date);
    }

    public static String Time(long Ticks) {
        DateTime d = DateTime.getInst();
        d.date.setTime(Ticks);
        return d.timeFormat.format(d.date);
    }

    public static String getTimeFormat() {
        return DateTime.getInst().timeFormat.toPattern();
    }

    public static void setTimeFormat(String Pattern2) {
        DateTime.getInst().timeFormat.applyPattern(Pattern2);
    }

    public static String getDateFormat() {
        return DateTime.getInst().dateFormat.toPattern();
    }

    public static void setDateFormat(String Pattern2) {
        DateTime.getInst().dateFormat.applyPattern(Pattern2);
    }

    public static long DateParse(String Date2) throws ParseException {
        return DateTime.getInst().dateFormat.parse(Date2).getTime();
    }

    public static String getDeviceDefaultDateFormat() {
        SimpleDateFormat sdf = (SimpleDateFormat)DateFormat.getDateInstance();
        return sdf.toPattern();
    }

    public static String getDeviceDefaultTimeFormat() {
        SimpleDateFormat sdf = (SimpleDateFormat)DateFormat.getTimeInstance();
        return sdf.toPattern();
    }

    public static long TimeParse(String Time2) throws ParseException {
        SimpleDateFormat tf = DateTime.getInst().timeFormat;
        tf.setTimeZone(zeroTimeZone);
        long time = 0L;
        try {
            time = tf.parse(Time2).getTime();
        }
        finally {
            tf.setTimeZone(DateTime.getInst().timeZone);
        }
        long offsetInMinutes = Math.round(DateTime.getTimeZoneOffset() * 60.0);
        long dayStartInUserTimeZone = System.currentTimeMillis() + offsetInMinutes * 60000L;
        dayStartInUserTimeZone -= dayStartInUserTimeZone % 86400000L;
        return (dayStartInUserTimeZone -= offsetInMinutes * 60000L) + time % 86400000L;
    }

    public static long DateTimeParse(String Date2, String Time2) throws ParseException {
        SimpleDateFormat df = DateTime.getInst().dateFormat;
        SimpleDateFormat tf = DateTime.getInst().timeFormat;
        df.setTimeZone(zeroTimeZone);
        tf.setTimeZone(zeroTimeZone);
        try {
            long dd = DateTime.DateParse(Date2);
            long tt = tf.parse(Time2).getTime();
            long total = dd + tt;
            int endShift = (int)(DateTime.GetTimeZoneOffsetAt(total) * 3600000.0);
            int startShift = (int)(DateTime.GetTimeZoneOffsetAt(total -= (long)endShift) * 3600000.0);
            long l = total += (long)(endShift - startShift);
            return l;
        }
        finally {
            tf.setTimeZone(DateTime.getInst().timeZone);
            df.setTimeZone(DateTime.getInst().timeZone);
        }
    }

    public static void SetTimeZone(double OffsetHours) {
        DateTime.setTimeZoneInternal(new SimpleTimeZone((int)Math.round(OffsetHours * 3600.0 * 1000.0), ""));
    }

    @BA.Hide
    public static void setTimeZoneInternal(TimeZone tz) {
        DateTime.getInst().timeZone = tz;
        DateTime.getInst().cal.setTimeZone(DateTime.getInst().timeZone);
        DateTime.getInst().dateFormat.setTimeZone(DateTime.getInst().timeZone);
        DateTime.getInst().timeFormat.setTimeZone(DateTime.getInst().timeZone);
    }

    public static double getTimeZoneOffset() {
        return (double)DateTime.getInst().timeZone.getOffset(System.currentTimeMillis()) / 3600000.0;
    }

    public static double GetTimeZoneOffsetAt(long Date2) {
        double d = (double)DateTime.getInst().timeZone.getOffset(Date2) / 3600000.0;
        return d;
    }

    public static int GetYear(long Ticks) {
        DateTime.getInst().cal.setTimeInMillis(Ticks);
        return DateTime.getInst().cal.get(1);
    }

    public static int GetMonth(long Ticks) {
        DateTime.getInst().cal.setTimeInMillis(Ticks);
        return DateTime.getInst().cal.get(2) + 1;
    }

    public static int GetDayOfMonth(long Ticks) {
        DateTime.getInst().cal.setTimeInMillis(Ticks);
        return DateTime.getInst().cal.get(5);
    }

    public static int GetDayOfYear(long Ticks) {
        DateTime.getInst().cal.setTimeInMillis(Ticks);
        return DateTime.getInst().cal.get(6);
    }

    public static int GetDayOfWeek(long Ticks) {
        DateTime.getInst().cal.setTimeInMillis(Ticks);
        return DateTime.getInst().cal.get(7);
    }

    public static int GetHour(long Ticks) {
        DateTime.getInst().cal.setTimeInMillis(Ticks);
        return DateTime.getInst().cal.get(11);
    }

    public static int GetSecond(long Ticks) {
        DateTime.getInst().cal.setTimeInMillis(Ticks);
        return DateTime.getInst().cal.get(13);
    }

    public static int GetMinute(long Ticks) {
        DateTime.getInst().cal.setTimeInMillis(Ticks);
        return DateTime.getInst().cal.get(12);
    }

    public static long Add(long Ticks, int Years, int Months, int Days) {
        Calendar c = DateTime.getInst().cal;
        c.setTimeInMillis(Ticks);
        c.add(1, Years);
        c.add(2, Months);
        c.add(6, Days);
        return c.getTimeInMillis();
    }

    /* synthetic */ DateTime(DateTime dateTime) {
        this();
    }
}

